/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.js.contentassist.JSModelFormatter;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.PropertyElement;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionArgumentProposal
extends CommonCompletionProposal
implements ICompletionProposalExtension5 {
    private JSIndexQueryHelper fgQueryHelper;
    protected IProject project;
    protected PropertyElement fProp;

    public FunctionArgumentProposal(String constant, int offset, int replaceLength, IProject project) {
        super(constant, offset, replaceLength, constant.length(), null, constant, null, null);
        this.project = project;
        this.setRelevance(100);
    }

    public String getFileLocation() {
        PropertyElement prop;
        if (this._fileLocation == null && (prop = this.getProperty()) != null) {
            this._fileLocation = JSModelFormatter.getTypeDisplayName(this.getProperty().getOwningType());
        }
        return super.getFileLocation();
    }

    public Image getImage() {
        PropertyElement prop;
        if (this._image == null && (prop = this.getProperty()) != null) {
            this._image = JSModelFormatter.ADDITIONAL_INFO.getImage(prop);
        }
        return super.getImage();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        PropertyElement prop = this.getProperty();
        if (prop == null) {
            return "";
        }
        return JSModelFormatter.ADDITIONAL_INFO.getDescription((BaseElement)prop, this.project.getLocationURI());
    }

    private synchronized PropertyElement getProperty() {
        if (this.fProp == null) {
            String fullName = this.getDisplayString();
            int index = StringUtil.lastIndexOf((String)fullName, (char[])new char[]{'.'});
            String typeName = null;
            String propName = null;
            if (index == -1) {
                typeName = JSTypeUtil.getGlobalType((IProject)this.project, null);
                propName = fullName;
            } else {
                typeName = fullName.substring(0, index);
                propName = fullName.substring(index + 1);
            }
            List<PropertyElement> props = this.lookupProperty(typeName, propName);
            if (!CollectionsUtil.isEmpty(props)) {
                this.fProp = props.get(0);
            }
        }
        return this.fProp;
    }

    protected List<PropertyElement> lookupProperty(String typeName, String propName) {
        return this.getQueryHelper().getProperties(typeName, propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSIndexQueryHelper getQueryHelper() {
        Class<FunctionArgumentProposal> clazz = FunctionArgumentProposal.class;
        synchronized (FunctionArgumentProposal.class) {
            if (this.fgQueryHelper == null) {
                this.fgQueryHelper = new JSIndexQueryHelper(this.project);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fgQueryHelper;
        }
    }
}

